/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RopeHelper {
    public static boolean addRopeDown(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock) {
        return RopeHelper.addRope(pos, level, player, hand, ropeBlock, Direction.DOWN, true, Integer.MAX_VALUE);
    }

    public static boolean addRope(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock, Direction moveDir, boolean canPush, int maxDist) {
        BlockEntity blockEntity;
        BlockState state = level.getBlockState(pos);
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveDir)) {
            return RopeHelper.addRope(pos.relative(moveDir), level, player, hand, ropeBlock, moveDir, canPush, maxDist);
        }
        if (state.is(ModRegistry.PULLEY_BLOCK.get()) && (blockEntity = level.getBlockEntity(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile te = (PulleyBlockTile)blockEntity;
            return te.rotateIndirect(player, hand, ropeBlock, moveDir, false);
        }
        return RopeHelper.tryPlaceAndMove(player, hand, level, pos, ropeBlock, moveDir, canPush);
    }

    public static boolean isCorrectRope(Block ropeBlock, BlockState state, Direction direction) {
        if (state.getBlock() instanceof ChainBlock && state.getValue((Property)ChainBlock.AXIS) != direction.getAxis()) {
            return false;
        }
        return ropeBlock == state.getBlock();
    }

    public static boolean tryPlaceAndMove(@Nullable Player player, InteractionHand hand, Level world, BlockPos pos, Block ropeBlock, Direction moveDir, boolean canPush) {
        BlockState state;
        ItemStack stack = new ItemStack((ItemLike)ropeBlock);
        BlockPlaceContext context = new BlockPlaceContext(world, player, hand, stack, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), moveDir.getOpposite(), pos, false));
        if (!context.canPlace()) {
            BlockPos downPos = pos.relative(moveDir);
            if (!(canPush && world.getBlockState(downPos).canBeReplaced() && RopeHelper.tryMove(pos, downPos, world))) {
                return false;
            }
            context = new BlockPlaceContext(world, player, hand, stack, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), moveDir.getOpposite(), pos, false));
        }
        if ((state = ItemsUtil.getPlacementState(context, ropeBlock)) == null) {
            return false;
        }
        if (state == world.getBlockState(context.getClickedPos())) {
            return false;
        }
        if (world.setBlock(context.getClickedPos(), state, 11)) {
            BlockState placedState;
            Block block;
            if (player != null && (block = (placedState = world.getBlockState(context.getClickedPos())).getBlock()) == state.getBlock()) {
                block.setPlacedBy(world, context.getClickedPos(), placedState, (LivingEntity)player, stack);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, context.getClickedPos(), stack);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isBlockMovable(BlockState state, Level level, BlockPos pos) {
        if (state.getBlock() instanceof PulleyBlock) {
            return false;
        }
        return !state.isAir() && !state.is(Blocks.OBSIDIAN) && !state.is(Blocks.SPAWNER) && !state.is(Blocks.CRYING_OBSIDIAN) && !state.is(Blocks.RESPAWN_ANCHOR) && state.getDestroySpeed((BlockGetter)level, pos) != -1.0f;
    }

    public static boolean removeRopeDown(BlockPos pos, Level level, Block ropeBlock) {
        return RopeHelper.removeRope(pos, level, ropeBlock, Direction.DOWN, Integer.MAX_VALUE);
    }

    public static boolean removeRope(BlockPos pos, Level level, Block ropeBlock, Direction moveUpDir, int maxDist) {
        PulleyBlockTile te;
        BlockEntity blockEntity;
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        BlockState state = level.getBlockState(pos);
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveUpDir)) {
            return RopeHelper.removeRope(pos.relative(moveUpDir), level, ropeBlock, moveUpDir, maxDist);
        }
        if (state.is(ModRegistry.PULLEY_BLOCK.get()) && (blockEntity = level.getBlockEntity(pos)) instanceof PulleyBlockTile && !(te = (PulleyBlockTile)blockEntity).isEmpty()) {
            return te.rotateIndirect(null, InteractionHand.MAIN_HAND, ropeBlock, moveUpDir, true);
        }
        BlockPos up = pos.relative(moveUpDir.getOpposite());
        if (level.getBlockState(up).getBlock() != ropeBlock) {
            return false;
        }
        FluidState fromFluid = level.getFluidState(up);
        boolean water = fromFluid.getType() == Fluids.WATER && fromFluid.isSource();
        level.setBlockAndUpdate(up, water ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState());
        RopeHelper.tryMove(pos, up, level);
        return true;
    }

    private static boolean tryMove(BlockPos fromPos, BlockPos toPos, Level level) {
        if (toPos.getY() < level.getMinBuildHeight() || toPos.getY() > level.getMaxBuildHeight()) {
            return false;
        }
        BlockState state = level.getBlockState(fromPos);
        PushReaction push = state.getPistonPushReaction();
        if (RopeHelper.isBlockMovable(state, level, fromPos) && ((push == PushReaction.NORMAL || toPos.getY() < fromPos.getY() && push == PushReaction.PUSH_ONLY) && state.canSurvive((LevelReader)level, toPos) || state.is(ModTags.ROPE_HANG_TAG))) {
            FluidState fromFluid;
            Fluid fluidState;
            BlockEntity tile = level.getBlockEntity(fromPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(state)) {
                    return false;
                }
                tile.setRemoved();
            }
            boolean waterFluid = (fluidState = level.getFluidState(toPos).getType()) == Fluids.WATER;
            boolean canHoldWater = false;
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                canHoldWater = state.is(ModTags.WATER_HOLDER);
                if (!canHoldWater) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterFluid));
                }
            } else if (state.getBlock() instanceof AbstractCauldronBlock) {
                if (waterFluid && state.is(Blocks.CAULDRON) || state.is(Blocks.WATER_CAULDRON)) {
                    state = (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
                }
                if (fluidState == Fluids.LAVA && state.is(Blocks.CAULDRON) || state.is(Blocks.LAVA_CAULDRON)) {
                    state = Blocks.LAVA_CAULDRON.defaultBlockState();
                }
            }
            boolean leaveWater = (fromFluid = level.getFluidState(fromPos)).getType() == Fluids.WATER && fromFluid.isSource() && !canHoldWater;
            level.setBlockAndUpdate(fromPos, leaveWater ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState());
            BlockState newState = Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)level, (BlockPos)toPos);
            level.setBlockAndUpdate(toPos, newState);
            if (tile != null) {
                CompoundTag tag = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                BlockEntity te = level.getBlockEntity(toPos);
                if (te != null) {
                    te.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
                }
            }
            level.neighborChanged(toPos, state.getBlock(), toPos);
            return true;
        }
        return false;
    }
}

